﻿//------------------------------------------------------------------------------
//  <copyright from='2010' to='2015' company='THEHACKERWITHIN.COM'>
//    Copyright (c) TheHackerWithin.COM. All Rights Reserved.
//
//    Please look in the accompanying license.htm file for the license that 
//    applies to this source code. (a copy can also be found at: 
//    http://www.thehackerwithin.com/license.htm)
//  </copyright>
//-------------------------------------------------------------------------------
namespace AntiAntiDebugLoader
{
    using System;
    using System.Linq;
    using System.Windows.Forms;
    using System.Diagnostics;
    using System.Runtime.InteropServices;

    public partial class MainForm : Form
    {
        [DllImport("AntiAntiDebug.dll")]
        public static extern int InjectDll(IntPtr hTarget);

        private Process[] _processes;

        public MainForm()
        {
            InitializeComponent();
        }

        private void ProcessListComboBox_DropDown(object sender, EventArgs e)
        {
            _processes = Process.GetProcesses().OrderBy(p => p.ProcessName).Where(p=> string.Compare(p.ProcessName, "svchost", true) != 0).ToArray();

            ProcessListComboBox.Items.Clear();
            foreach (var process in _processes)
                ProcessListComboBox.Items.Add(process.ProcessName);
        }

        private void ProcessListComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ProcessListComboBox.SelectedIndex < 0)
                return;

            InjectDll(_processes[ProcessListComboBox.SelectedIndex].Handle);
            MessageBox.Show("AntiAntiDebugger injected into " + _processes[ProcessListComboBox.SelectedIndex].ProcessName);

            ProcessListComboBox.SelectedIndex = -1;
        }
    }
}
