//------------------------------------------------------------------------------
//  <copyright from='2010' to='2015' company='THEHACKERWITHIN.COM'>
//    Copyright (c) TheHackerWithin.COM. All Rights Reserved.
//
//    Please look in the accompanying license.htm file for the license that 
//    applies to this source code. (a copy can also be found at: 
//    http://www.thehackerwithin.com/license.htm)
//  </copyright>
//-------------------------------------------------------------------------------

// dllmain.cpp : Defines the entry point for the DLL application.
#define _M_IX86
#include "stdafx.h"
#include "DetourXS/detourxs.h"

typedef BOOL (WINAPI *tCreateProcessW)(
  LPCTSTR lpApplicationName,
  LPTSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCTSTR lpCurrentDirectory,
  LPSTARTUPINFOW lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
);

typedef BOOL (WINAPI *tCreateProcessA)(
  LPCSTR lpApplicationName,
  LPSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCSTR lpCurrentDirectory,
  LPSTARTUPINFOA lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
);

typedef BOOL (WINAPI * tNtSetInformationThread)(
  HANDLE ThreadHandle, 
  ULONG ThreadInformationClass, 
  PVOID ThreadInformation, 
  ULONG ThreadInformationLength
);

char modulePath[_MAX_PATH];
extern "C" __declspec(dllexport) void InjectDll(HANDLE hTarget)
{
	HANDLE  hThread;
	void*   pLibRemote;				// The address (in the remote process) where szLibPath will be copied to;
	DWORD   hLibModule;				// Base address of loaded module (==HMODULE);
	HMODULE hKernel32 = GetModuleHandle(TEXT("Kernel32"));

	// Allocate remote memory
	pLibRemote = VirtualAllocEx(hTarget, NULL, sizeof(modulePath), MEM_COMMIT, PAGE_READWRITE);

	// Copy library name
	WriteProcessMemory(hTarget, pLibRemote, modulePath, sizeof(modulePath), NULL);

	// Load dll into the remote process
	hThread = CreateRemoteThread(hTarget, NULL, 0, (LPTHREAD_START_ROUTINE) GetProcAddress(hKernel32, "LoadLibraryA"), pLibRemote, 0, NULL);
	WaitForSingleObject(hThread, INFINITE );

	// Get handle of the loaded module
	GetExitCodeThread( hThread, &hLibModule );

	// Clean up
	CloseHandle(hThread);
	VirtualFreeEx(hTarget, pLibRemote, sizeof(modulePath), MEM_RELEASE);
}

tCreateProcessA orgCreateProcessA;

BOOL WINAPI hookCreateProcessA(
  LPCSTR lpApplicationName,
  LPSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCSTR lpCurrentDirectory,
  LPSTARTUPINFOA lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
)
{
	bool wasSuspended = (dwCreationFlags & CREATE_SUSPENDED) != 0;
	dwCreationFlags |= CREATE_SUSPENDED;
	BOOL result = orgCreateProcessA(lpApplicationName, lpCommandLine, lpProcessAttributes, lpThreadAttributes, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory, lpStartupInfo, lpProcessInformation);
	
	// Did we succeed?
	if (result)
	{
		// Inject the DLL
		InjectDll(lpProcessInformation->hProcess);

		if (!wasSuspended)
		{
			// Resume application
			ResumeThread(lpProcessInformation->hThread);
		}
	}

	return result;
}

tCreateProcessW orgCreateProcessW;

BOOL WINAPI hookCreateProcessW(
  LPCTSTR lpApplicationName,
  LPTSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCTSTR lpCurrentDirectory,
  LPSTARTUPINFOW lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
)
{
	bool wasSuspended = (dwCreationFlags & CREATE_SUSPENDED) != 0;
	dwCreationFlags |= CREATE_SUSPENDED;
	BOOL result = orgCreateProcessW(lpApplicationName, lpCommandLine, lpProcessAttributes, lpThreadAttributes, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory, lpStartupInfo, lpProcessInformation);
	
	// Did we succeed?
	if (result)
	{
		// Inject the DLL
		InjectDll(lpProcessInformation->hProcess);

		if (!wasSuspended)
		{
			// Resume application
			ResumeThread(lpProcessInformation->hThread);
		}
	}

	return result;
}

tNtSetInformationThread orgNtSetInformationThread;

BOOL WINAPI hookNtSetInformationThread(
  HANDLE ThreadHandle, 
  ULONG ThreadInformationClass, 
  PVOID ThreadInformation, 
  ULONG ThreadInformationLength
)
{
	// Ignore the ThreadHideFromDebugger flag
	if (ThreadInformationClass == 0x11)
		return TRUE;

	return orgNtSetInformationThread(ThreadHandle, ThreadInformationClass, ThreadInformation, ThreadInformationLength);
}

DetourXS * detourCreateProcessA = NULL;
DetourXS * detourCreateProcessW = NULL;
DetourXS * detourNtSetInformationThread = NULL;

BOOL APIENTRY DllMain(HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	// Get a reference to ZwSetInformationThread
	tNtSetInformationThread NtSetInformationThread = (tNtSetInformationThread)GetProcAddress(GetModuleHandle(TEXT("ntdll.dll")),"ZwSetInformationThread");

	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		// Initialize ModulePath
		GetModuleFileNameA(hModule, modulePath, sizeof(modulePath));

		detourCreateProcessA = new DetourXS(&CreateProcessA, hookCreateProcessA);
		orgCreateProcessA = (tCreateProcessA) detourCreateProcessA->GetTrampoline();

		detourCreateProcessW = new DetourXS(&CreateProcessW, hookCreateProcessW);
		orgCreateProcessW = (tCreateProcessW) detourCreateProcessW->GetTrampoline();

		detourNtSetInformationThread = new DetourXS((LPVOID)NtSetInformationThread, hookNtSetInformationThread);
		orgNtSetInformationThread = (tNtSetInformationThread) detourNtSetInformationThread->GetTrampoline();
		break;

	case DLL_PROCESS_DETACH:
		detourCreateProcessA->Destroy();
		detourCreateProcessW->Destroy();
		detourNtSetInformationThread->Destroy();
		break;
	}
	return TRUE;
}

